//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "stereo.h"
#include "fkula.h"
#include <math.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
 odczytaj_parametry();
}
//---------------------------------------------------------------------------
// Odczytaj parametry
void TForm1 :: odczytaj_parametry( void)
{
 try
 {
    sp = (StylPatrzenia)RadioGroup1 -> ItemIndex;
    if( sp == Anaglif)
    {
        Lkolor = clRed;
        Rkolor = clAqua;
    }
    else
    {
        Lkolor = Rkolor = clBlack;
    }
    baza = (double)TrackBar1 -> Position / 100.;
    obserwator.x = (double)TrackBar2 -> Position / 10.;
    obserwator.y = (double)TrackBar3 -> Position / 10.;
    obserwator.z = (double)TrackBar4 -> Position / 10.;
    ogniskowa = (double)TrackBar5 -> Position/100.;
 }
 catch(...)
 {
 }
}
//---------------------------------------------------------------------------
//  Wykrelenie kostki, rozpitej na podanych wierzchokach
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
 TStereo s( obserwator,         //pozycja obserwatora
    0, 0, PaintBox1 -> Width, PaintBox1 -> Height, //okienko ekranowe
    baza,                       //odlego midzy oczami
    PaintBox1 -> Canvas,        //aparat graficzny
    sp,                         //styl projekcji stereo
    ogniskowa);                 //odlego oka od paszczyzny obrazowej

 double r = 1, fi, teta, dfi = M_PI/10., dteta = M_PI/10.;
 double rr, x, y, z;
 TPunkt p1, p2;
 bool pierwszy_punkt;

 for( teta = 0.; teta <= M_PI; teta += dteta)   //rwnoleniki
 {
    rr = r * sin( teta);
    z = r * cos( teta);
    pierwszy_punkt = true;
    for( fi = 0.; fi >= -2.0*(M_PI + .01); fi -= dfi)
    {
        x = rr * cos( fi);
        y = rr * sin( fi);
        if( pierwszy_punkt)
        {
            pierwszy_punkt = false;
            p2 = TPunkt( x, y, z);
        }
        else
        {
            p1 = p2;
            p2 = TPunkt( x, y, z);
            s.linia_stereo( p1, p2, Lkolor, Rkolor);
        }
    }
 }

 for( fi = 0.; fi >= -2.0*(M_PI + .01); fi -= dfi)  //poudniki
 {
    pierwszy_punkt = true;

    for( teta = 0.; teta <= M_PI; teta += dteta)
    {
        rr = r * sin( teta);
        z = r * cos( teta);
        x = rr * cos( fi);
        y = rr * sin( fi);
        if( pierwszy_punkt)
        {
            pierwszy_punkt = false;
            p2 = TPunkt( x, y, z);
        }
        else
        {
            p1 = p2;
            p2 = TPunkt( x, y, z);
            s.linia_stereo( p1, p2, Lkolor, Rkolor);
        }
    }
 }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
 odczytaj_parametry();
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyPress(TObject *Sender, char &Key)
{
 if( Key == VK_ESCAPE)
    Close();
}
//---------------------------------------------------------------------------

